/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xdynamic.h
 *       dynamic capabilities for parameter checking
 * -----------------------------------------------------------------*/

#ifndef XDYNAMIC_H_INCLUDED
#define XDYNAMIC_H_INCLUDED

#include <xdyndefs.h>

#define BX_INDEX_SEARCH  1
#define BX_ENUM_SEARCH   2
#define BX_NAME_SEARCH 3
#define BX_CLINAME_SEARCH 4


#ifdef __cplusplus
extern "C" {
#endif

/* -----------------------------------------------------------------------
 * Dynamic Capabilities functions
 * ----------------------------------------------------------------------- */

#ifndef SWIG
/* initializing and setting the information (and deleting it afterwards) */
bx_errtype EXPORT BestXCapaInit(
  bx_handletype    handle
);

bx_errtype EXPORT BestXCapaClose( 
  bx_handletype    handle
);

bx_errtype EXPORT BestXIHWCapabilityGet(
  bx_handletype handle, 
  bx_int32 * lic
);


#ifndef BEST_FIRMWARE

bx_errtype EXPORT BestXAddParam(
  bx_param_infotype ** anchor,      /* add the data to this list */
  bx_int32 num_elems,               /* how many elements do we have without the new one */
  bx_charptrtype param_name,        /* namestring of standard form */
  bx_charptrtype param_short,       /* namestring of the short form */
  bx_ccharptrtype param_propname,   /* namestring: CAPI form (BX_...)  */
  bx_int32 min_val,                 /* maximum value also bitstart(signal) */
  bx_int32 max_val,                 /* minimum value also bitend (signal) */
  bx_int32 defaultval,              /* default value of this parameter */
  bx_charptrtype defaultstr,        /* default string of this parameter */
  bx_int32 paramrule,               /* param might have a special rule */
  bx_int32 proptyp,                 /* property for the C-API call (union) */
  const bx_param_stringlisttype * stringlist, /* array of possible strings */
  bx_int32 grouptyp,                /* what group the property belongs to */
  const bx_memmaptype * memmap      /* the memory map */
  );


  bx_errtype EXPORT BestXParamProbe (
  bx_handletype        handle,
  bx_paramtype         param_typ,   /* what kind of parameter at all */      
  bx_int32             parnum
    );


/* check a specific parameter if it is within the bounds */
/* used within the C-API to check parameters */
  bx_errtype EXPORT BestXParamCheck(      
  bx_handletype        handle,
  bx_paramtype         param_typ,   /* what kind of parameter at all */      
  bx_int32             prop_typ,    /* the parameter itself (autocast)*/
  bx_int32             value        /* and the value */
    );

/*---------------------------------------------------------------------------*
 * EXPORT bx_errtype BestXInfoGet (
 *
 * Purpose: externally visible version, just calls IBestXInfoGet
 *---------------------------------------------------------------------------*/
bx_errtype EXPORT BestXInfoGet (
  bx_handletype handle,
  bx_paramtype param,
  const bx_infotype ** info
  );

/* search for specific property in info struct */
  bx_errtype EXPORT BestXParamSearch (
    const bx_infotype * info,  /* info array */
    bx_intptr propVal,         /* property index/type/string */
    bx_int64 option,           /* search option (index, enum, string, cli) */
    bx_int32 * index           /* index into info->parinfo array */
    );

/* check ranges etc. based on info in paramInfo struct */
bx_errtype EXPORT BestXParamRangeCheck(
  bx_handletype handle,
  const bx_param_infotype * paramInfo,
  bx_int32 value
  );

/* return the generic information struct for one of the blocks */
/* used by the GUI or application to obtain block related information */
  bx_errtype EXPORT BestXGenInfoGet(
  bx_handletype handle,
  bx_paramtype             param_typ,   /* what kind of param block at all */
  const bx_generic_infotype **   geninfo    /* the info struct */
    );

/* return the information struct for a specific parameter */
/* used by the GUI or application to obtain parameter related information */
  bx_errtype EXPORT BestXParamInfoGet(
  bx_handletype handle,
  bx_paramtype           param_typ,   /* what kind of parameter at all */    
  bx_int32               parnum,      /* the parameter itself (as a number)*/
  const bx_param_infotype **   paraminfo,   /* the info struct */ 
  bx_int32               option     /*how to search for param(index or enum)*/
);



#endif /* defined BEST_FIRMWARE */
#endif /* ifndef SWIG */

CLI bx_errtype EXPORT BestXCapabilityCheck( /* @capachk */
  bx_handletype        handle,
  bx_int32             capa_code   /* @code */
);

CLI bx_errtype EXPORT BestXCapabilityRead( /* @caparead */
  bx_handletype        handle,
  bx_int32       *     capa_code   /* #RETURN "0x%08x" */
);

CLI bx_errtype EXPORT BestXPrintDefaults ( /* @printdefaults */
  bx_handletype handle,
  bx_charptrtype fileName /* @file */
);

/* ---------- non-CLI exported functions: ------------- */
const bx_charptrtype EXPORT BestXParamValue2String (
  const bx_param_stringlisttype * thelist,
  bx_int32 value,
  bx_charptrtype retStr,
  bx_int32 base
  );

const bx_charptrtype EXPORT BestXParamString2Value (
  const bx_param_stringlisttype * thelist,
  bx_ccharptrtype valSt,
  bx_int32 * pValue
  );

void EXPORT BestXParamValueListGet (
  const bx_param_infotype * pParamInfo,
  bx_int32 minVal,
  bx_int32 maxVal,
  bx_ccharptrtype separator,
  bx_charptrtype buffer
  );

/*------------- non-CLI non-exported --------------------*/
char * BestXDynamicErrorStringGet(
  bx_handletype handle,
  bx_int64 group, 
  bx_int64 param,
  bx_int64 minval, 
  bx_int64 maxval,
  bx_int64 val,
  bx_errtype theerr,
  char * buf
  );

/* private function */
  bx_errtype EXPORT BestXIHWCapabilitySet( bx_handletype handle,bx_int32* capa);
           

#ifdef __cplusplus
}
#endif

#endif
